package edu.unl.consystlab.sudokuSolver;

import java.util.List;
import java.util.LinkedList;


public class binaryIntensiveConstraint extends binaryConstraint implements
		intensiveConstraint {

	protected List myScope;
	
	public binaryIntensiveConstraint(String constraintScopeString, constraintProblem currentProblem) 
	{
		super(constraintScopeString, currentProblem);

		//parentProblem = currentProblem;
		myScope = new LinkedList();
		myScope = parseScope(constraintScopeString);

		currentProblem.addBinaryIntensiveConstraint(this, myScope);

		//tell the variables in the scope about this constraint
		for(int i=0; i<myScope.size(); i++)
		{
			((problemVariable)myScope.get(i)).addBinaryIntensiveConstraint(this);
		}
	}

	public boolean check(String value1, String value2)
	{
		if (value1.compareTo(value2) == 0)
			return ( false );
		return (true);
	}
	
	public String toString()
	{
		return (((problemVariable)myScope.get(0)).getIndex() + ";" + ((problemVariable)myScope.get(1)).getIndex());
	}
	
	public boolean isViolated()
	{
		//see if they are both assigned the same thing.
		if( ((problemVariable)myScope.get(0)).isAssigned() && ((problemVariable)myScope.get(1)).isAssigned() &&
				((problemVariable)myScope.get(0)).getAssigned().equals(((problemVariable)myScope.get(1)).getAssigned()) )
		{
			return true;
		}
		//check if one is assigned and the other only has one value which is the same as that value
		else if( ((problemVariable)myScope.get(0)).isAssigned() && ((problemVariable)myScope.get(1)).getCurrentDomainSize() == 1 &&
				((problemVariable)myScope.get(1)).isInCurrentDomain(((problemVariable)myScope.get(0)).getAssigned())
				)
		{
			return true;
		}
		//check if one is assigned and the other only has one value which is the same as that value
		else if( ((problemVariable)myScope.get(1)).isAssigned() && ((problemVariable)myScope.get(0)).getCurrentDomainSize() == 1 &&
				((problemVariable)myScope.get(0)).isInCurrentDomain(((problemVariable)myScope.get(1)).getAssigned())
				)
		{
			return true;
		}
		//check if they both have only one value left in their domains and it is the same value.
		else if( ((problemVariable)myScope.get(0)).getCurrentDomainSize() == 1 && ((problemVariable)myScope.get(1)).getCurrentDomainSize() == 1 &&
				((problemVariable)myScope.get(1)).isInCurrentDomain( (String)((LinkedList)((problemVariable)myScope.get(0)).getEntireDomain()).get(0))
				)
		{
			return true;
		}
		
		return false;
	}
	
	
}
